<?php

/**
 * Sends emails according to the specified Content Upgrade options
 */
class AopsEmailManager extends Aops {
	
	private $cu_id = 0;
	private $cuMeta = array();
	private $options = array();
	private $entry = false;
	
	private $replacements = array(
		'{user_first_name}'			=> array('entry', 'name'),
		'{user_email}'				=> array('entry', 'email'),
		'{date_of_entry}'			=> array('entry', 'created_at'),
		'{content_upgrade_title}'	=> array('cuMeta', 'title'),
		'{bonus_content_title_link}'=> array('function', 'getBonusContentLink'),
		'{bonus_content_file}'		=> array('cuMeta', 'bonus_content_path'),
	);
	
	public function __construct($cu_id) {
		$cu_id = intval($cu_id);
		if ($cu_id > 0) {
			$this->cu_id = $cu_id;
			$this->cuMeta = $this->getMeta($cu_id);
			
			// little hack to conveniently store Content Upgrade Title for later use
			$this->cuMeta['title'] = get_the_title($cu_id);
			$this->options = $this->getOptions();
		}
	}
	
	public function sendEmails($entry) {
		if (get_class($entry) == 'AopsEntry') {
			$this->entry = (array) $entry;
			
			if (!$this->options['default_admin_email_enabled']) { // NOTE: Checking this box DISABLES admin emails
				if ($this->cuMeta['admin_email_enabled']) {
					$this->sendEmailToAdmin();
				}
			}
			
			if ($this->cuMeta['user_email_enabled']) {
				$this->sendEmailToUser();
			}
		}
	}
	
	private function sendEmailToAdmin() {
		$to = $this->cuMeta['admin_email_address'];
		if (!$to) {
			$to = get_option('admin_email'); 
		}
		$subject = $this->processFieldReplacements($this->cuMeta['admin_email_subject']);
		$message = nl2br($this->processFieldReplacements($this->cuMeta['admin_email_body']));
		$headers = array('Content-Type: text/html; charset=UTF-8');
		$result = wp_mail($to, $subject, $message, $headers);
		$data = "Admin wp_mail<pre> $to, $subject, $message </pre>result = $result";
		Aops::log($data);
	}
	
	private function sendEmailToUser() {
		$to = $this->entry['email'];
		$subject = $this->processFieldReplacements($this->cuMeta['user_email_subject']);
		$message = nl2br($this->processFieldReplacements($this->cuMeta['user_email_body']));
		
		$adminEmail = get_option('admin_email');

		$fromEmail = trim($this->options['from_email']);
		
		if (!$fromEmail) {
			$fromEmail = $adminEmail; 
		}
		
		$fromName = trim($this->options['from_name']);

		if (!$fromName) {
			$adminInfo = get_user_by( 'email', $adminEmail);
			$fromName =  trim($adminInfo->first_name . ' ' . $adminInfo->last_name);
		}
		
		$fromHeader = $fromName ? "From: $fromName <$fromEmail>" : "From: $fromEmail";
		
		$headers = array(
			'Content-Type: text/html; charset=UTF-8',
			$fromHeader
		);

		$result = wp_mail($to, $subject, $message, $headers);
		
		$data = "User wp_mail<pre> $to, $subject, $message </pre>result = $result " . print_r($headers, 1) ;
		
		Aops::log($data);
	}
	
	/**
	 * Replaces {some_value} with actual value
	 * @see $this->replacements
	 */
	private function processFieldReplacements($message) {
		foreach ($this->replacements as $search => $address) {
			$arrayName = $address[0];
			$arrayKey = $address[1];
			
			switch($arrayName) {
				case 'entry':
				case 'cuMeta':
					$r = $this->$arrayName;
					$replace = $r[$arrayKey];
					break;
				case 'function':
					$functionName = $arrayKey;
					$replace = $this->$functionName();
					break;
				default:
					$replace = $search;
			}
			$message = str_replace($search, $replace, $message);
		}
		
		return $message;
	}
	
	private function getBonusContentLink() {
		$contentTitle = $this->cuMeta['title'];
		$contentUrl = $this->cuMeta['bonus_content_path'];
		
		$contentLink = '<a href="' . $contentUrl . '">' .  $contentTitle . '</a>';
		
		return $contentLink;
	}
}
?>
